/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.message;

import filenet.vw.apps.taskman.VWTaskActionCommand;
import filenet.vw.apps.taskman.VWTaskNumericProperty;
import filenet.vw.apps.taskman.VWTaskOkButtonPanel;
import filenet.vw.apps.taskman.VWTaskTabPanel;
import filenet.vw.apps.taskman.VWTaskUtil;
import filenet.vw.apps.taskman.resources.VWResource;
import filenet.vw.apps.taskman.toolkit.VWTaskJComboBox;
import filenet.vw.base.logging.Level;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;

public class VWConsoleMsgOptionsDialog
extends VWModalDialog
implements ActionListener {
    private Frame m_parent = null;
    private int m_userChoice = 1;
    private JComboBox m_messageLevelCombo = null;
    private VWTaskNumericProperty m_maxMessages = null;
    private VWTaskTabPanel m_mainPanel = null;
    public static final int OK = 0;
    public static final int CANCEL = 1;
    private static final int WIDTH = 375;
    private static final int HEIGHT = 325;
    private static final String[] MESSAGE_LEVELS = new String[]{VWResource.Error, VWResource.Warning, VWResource.Info};

    public VWConsoleMsgOptionsDialog(Frame parent, Level messageLevel, int maxMessages) throws Exception {
        super(parent);
        this.m_parent = parent;
        this.setTitle(VWResource.ConsoleOptions);
        this.getContentPane().setLayout(new BorderLayout());
        Dimension dim = VWStringUtils.stringToDimension("385,155");
        if (dim != null) {
            this.setSize(dim);
        } else {
            this.setSize(375, 325);
        }
        this.m_messageLevelCombo = new VWTaskJComboBox(MESSAGE_LEVELS);
        if (messageLevel.equals(Level.SEVERE)) {
            this.m_messageLevelCombo.setSelectedItem(VWResource.Error);
        } else if (messageLevel.equals(Level.WARNING)) {
            this.m_messageLevelCombo.setSelectedItem(VWResource.Warning);
        } else if (messageLevel.equals(Level.INFO)) {
            this.m_messageLevelCombo.setSelectedItem(VWResource.Info);
        }
        this.m_maxMessages = new VWTaskNumericProperty(Integer.toString(maxMessages), "####");
        this.m_mainPanel = this.getMainPanel();
        this.getContentPane().add((Component)this.m_mainPanel, "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "Last");
    }

    public int getUserChoice() {
        return this.m_userChoice;
    }

    public Level getMessageLevel() {
        String level = (String)this.m_messageLevelCombo.getSelectedItem();
        if (level.equals(VWResource.Error)) {
            return Level.SEVERE;
        }
        if (level.equals(VWResource.Warning)) {
            return Level.WARNING;
        }
        return Level.INFO;
    }

    public int getMaxMessages() {
        return Integer.parseInt(this.m_maxMessages.getText());
    }

    public void actionPerformed(ActionEvent event) {
        String actionCMD = event.getActionCommand();
        boolean keepVisible = false;
        if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.OK) == 0) {
            try {
                this.m_mainPanel.validateTextFields();
                this.m_userChoice = 0;
            }
            catch (Exception e) {
                keepVisible = true;
            }
        } else {
            this.m_userChoice = 1;
        }
        this.setVisible(keepVisible);
    }

    private VWTaskTabPanel getMainPanel() {
        GridBagConstraints LABEL_CONSTRAINTS = new GridBagConstraints();
        LABEL_CONSTRAINTS.anchor = 23;
        LABEL_CONSTRAINTS.insets = new Insets(5, 10, 5, 5);
        LABEL_CONSTRAINTS.fill = 0;
        LABEL_CONSTRAINTS.gridwidth = 1;
        LABEL_CONSTRAINTS.weightx = 0.0;
        GridBagConstraints FIELD_CONSTRAINTS = new GridBagConstraints();
        FIELD_CONSTRAINTS.anchor = 23;
        FIELD_CONSTRAINTS.insets = new Insets(5, 10, 5, 5);
        FIELD_CONSTRAINTS.fill = 2;
        FIELD_CONSTRAINTS.gridwidth = 0;
        FIELD_CONSTRAINTS.weightx = 1.0;
        VWTaskTabPanel panel = new VWTaskTabPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)new JLabel(VWResource.ConsoleMessageLevel + ":"), LABEL_CONSTRAINTS);
        panel.add((Component)this.m_messageLevelCombo, FIELD_CONSTRAINTS);
        this.m_maxMessages.setName(VWResource.MaximumMessages);
        panel.add((Component)new JLabel(this.m_maxMessages.getName() + ":"), LABEL_CONSTRAINTS);
        panel.add((JTextComponent)this.m_maxMessages, (Object)FIELD_CONSTRAINTS, true);
        VWTaskUtil.updateComponentOrientation(panel);
        return panel;
    }

    private JPanel getButtonPanel() {
        VWTaskOkButtonPanel panel = new VWTaskOkButtonPanel();
        panel.addActionListener(this);
        return panel;
    }
}

